from travel.avia.library.python.common.utils.dcutils import Replica, ReplicaInfo

from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info import MdbAPI, MYSQL_API_BASE_URL


def get_replica_info(settings, current_dc):
    # type: (dict, str) -> ReplicaInfo
    cluster_id = settings['MYSQL_CLUSTER_ID']
    default_master = 'c-{}.rw.db.yandex.net'.format(cluster_id)
    default_slaves = ['c-{}.ro.db.yandex.net'.format(cluster_id)]

    mdb_api = MdbAPI(
        api_base_url=MYSQL_API_BASE_URL,
        oauth_token=settings['MDB_API_TOKEN'],
    )
    mdb_api.add_default_cluster_info(
        cluster_id=cluster_id,
        master_hostname=default_master,
        hostnames=default_slaves,
    )
    cluster_info = mdb_api.get_cluster_info(cluster_id)
    cluster_info.sort_replicas_by_dc(current_dc)

    replicas = []
    for instance in cluster_info.instances:
        replica = Replica(
            instance.hostname,
            instance.dc,
            instance.dc,
        )
        replica.dc_local = replica.dc == current_dc

        if instance.is_master:
            replica.is_master = True

        replicas.append(replica)

    return ReplicaInfo(default_master, replicas)
