from django.conf import settings


class Host:
    def process_request(self, request):
        request.host = request.META.get("HTTP_HOST") or settings.HOST
        request.port = ''

        if ':' in request.host:
            request.host, port = request.host.rsplit(':', 1)
            request.port = ':' + port

        request.root_domain = 'ru'

        if '.' in request.host:
            request.root_domain = request.host.rsplit('.', 1)[1]

        request.tld = 'ru'

        for tld in ['ru', 'by', 'kz', 'ua', 'com', 'com.tr']:
            if request.host.endswith('.' + tld):
                request.tld = tld
                break
