from django.conf import settings
from django.utils import translation

from travel.avia.library.python.common.utils.ya import detect_lang


class Language:
    def process_request(self, request):
        lang, request.supported_langs = settings.DOMAIN_LANGUAGE_MAP['ru']

        request.domain_lang = lang

        if 'lang' in request.GET:
            lang = request.GET['lang']

        elif 'locale' in request.GET:
            lang = request.GET['locale']

        else:
            if request.path.startswith('/admin/'):
                if request.tld == 'ru':
                    request.maps_language = 'ru'
                    lang = 'ru'

                else:
                    lang = 'en'

                    if request.tld == 'com.tr':
                        request.maps_language = 'tr'

                    else:
                        request.maps_language = 'en'

            else:
                for domain, (domain_lang, supported_langs) in settings.DOMAIN_LANGUAGE_MAP.items():
                    if request.host == domain or request.host.endswith('.' + domain):
                        request.supported_langs = supported_langs

                        request.domain_lang = domain_lang

                        lang = detect_lang(request)

                        break

        translation.activate(lang)

        request.LANGUAGE_CODE = translation.get_language()

        translation.marktrans = request.GET.get('marktrans')
