# -*- coding: utf-8 -*-

import locale
import logging

from django.conf import settings
from travel.avia.library.python.common.middleware.mda import RU_EXTRA_DOMAINS

log = logging.getLogger(__name__)


class Locale:
    def process_request(self, request):
        request.passport_host = 'passport.yandex.' + request.tld

        # Для доменов КУБР используем passport.yandex.ru
        for domain in RU_EXTRA_DOMAINS:
            if request.host.endswith(domain):
                request.passport_host = 'passport.yandex.ru'

        request.passport_url = 'https://%s/passport' % request.passport_host
        request.social_host = 'social.yandex.' + request.tld

        if request.tld in ['ru', 'by', 'kz', 'ua']:
            request.clck_host = 'clck.yandex.ru'
            request.tune_host = 'tune.yandex.ru'
        else:
            request.clck_host = 'clck.yandex.%s' % request.tld
            request.tune_host = 'tune.yandex.%s' % request.tld

        def yandex_subdomain(subdomain):
            return '%s.yandex.%s' % (subdomain, request.tld)

        request.yandex_subdomain = yandex_subdomain

        request.yandex_subdomain_url = lambda subdomain: "http://%s/" % yandex_subdomain(subdomain)

        request.yandex_link = 'http://%s/' % request.yandex_subdomain('www')

        request.show_ticket_links = request.tld in ['ru', 'ua', 'kz', 'by']

        request.ticket_url = '//avia.yandex.%s/' % request.tld

        request.NATIONAL_VERSION = settings.DOMAIN_TO_NATIONAL_VERSION.get(request.host.split('.')[-1], 'ru')

        request.feedback_url = self.get_feedback_url_by_national_version_and_tld(request.NATIONAL_VERSION, request.tld)

        request.metrika_id = settings.NATIONAL_VERSION_TO_METRIKA[request.NATIONAL_VERSION]

        if request.NATIONAL_VERSION in ('ua', 'ru'):
            self.set_collate_locale('ru_RU.UTF8')  # Правильно сортируем украинские строки

        elif request.NATIONAL_VERSION == 'tr':
            self.set_collate_locale('tr_TR.UTF8')  # Правильно сортируем турецкие строки

    def set_collate_locale(self, locale_key):
        try:
            locale.setlocale(locale.LC_COLLATE, locale_key)
        except locale.Error:
            locale.setlocale(locale.LC_COLLATE, 'C')
            log.error(u'Не удалось установить локаль %s' % locale_key)

    def get_feedback_url_by_tld(self, tld):
        return '//yandex.{}/support/rasp/troubleshooting.xml?form1645-answer_short_text_25924=desktop'.format(tld)

    def get_feedback_url_by_national_version_and_tld(self, national_version, tld):
        # RASPFRONT-1804 Ссылка на обратную связь в BY и KZ версиях должна вести на RU ФОС
        return self.get_feedback_url_by_tld('ru' if national_version == 'ru' else tld)
