from travel.avia.library.python.common.utils import mobiledetector


class MobileDetect:
    def process_request(self, request):
        request.device_class = None
        request.js_mobile = False
        request.canring = False
        request.ipad = False
        request.opera = False

        if "iPad;" in request.META.get('HTTP_USER_AGENT', ''):
            request.ipad = True

        try:
            info = mobiledetector.detect(request)
            request.device_class = info['device-class']
            request.canring = info['canring']
            if request.device_class:
                request.js_mobile = request.device_class in ['android', 'iphoneos']

                for header in ('X-Browser', 'User-Agent'):
                    if header in request.META and 'Opera' in request.META[header]:
                        request.js_mobile = False
                        request.opera = True

        except mobiledetector.InfoError:
            pass
