# -*- coding: utf-8 -*-

import MySQLdb
import logging
from subprocess import Popen, PIPE

from django.conf import settings
from travel.avia.library.python.common.utils.threadutils import run_in_thread

log = logging.getLogger(__name__)


class MysqlErrorHandler:
    def log_traceroute(self, exception):
        stdout, stderr = Popen(["/usr/bin/traceroute", settings.DATABASES['default']['HOST']],
                               stdout=PIPE, stderr=PIPE).communicate()

        log.warning("MySQL error\n%s\n%s%s" % (exception, stderr, stdout))

    def process_exception(self, request, exception):
        if settings.DATABASES['default']['HOST']:
            if isinstance(exception, MySQLdb.OperationalError):
                run_in_thread(self.log_traceroute, args=[exception])
