import datetime

from travel.avia.library.python.common.utils import environment
from travel.avia.library.python.common.utils.date import MSK_TZ


class Now:
    def process_request(self, request):
        try:
            now = datetime.datetime.strptime(request.GET['now'], '%Y-%m-%d %H:%M')
        except (KeyError, ValueError):
            now = environment.now()

        request.msk_now = MSK_TZ.localize(now)
        request.now = request.msk_now
        request.naive_msk_now = request.msk_now.replace(tzinfo=None)
