# -*- coding: utf-8 -*-

from travel.avia.library.python.common.utils import environment
from django.utils import translation


class RequestActivator:
    def process_exception(self, request, exception):
        environment.deactivate_request()

    def process_request(self, request):
        # Сбрасываем язык
        translation.activate('ru')
        environment.activate_request(request)

    def process_response(self, request, response):
        environment.deactivate_request()

        return response
