# -*- coding: utf-8 -*-


class UatraitsDetectorMiddleware(object):
    """
    https://wiki.yandex-team.ru/morda/browserdetect/
    """

    def __init__(self):
        self.detector = self._get_detector()

    def process_request(self, request):
        if 'HTTP_USER_AGENT' not in request.META:
            request.uatraits_result = {}
            return

        request.uatraits_result = self.detector.detect(request.META['HTTP_USER_AGENT'])

    def _get_detector(self):
        import uatraits
        return uatraits.detector('/usr/share/uatraits/browser.xml')
