# -*- coding: utf-8 -*-

import cgi
import urllib

from django.http import QueryDict


class URLEncodingHack(object):
    """
        Хак для решения проблемы с кодировками в CommonMiddleware:
        https://code.djangoproject.com/ticket/15152

        Если в QUERY_STRING попадаются не-ascii символы, которых там быть не
        должно, то превращаем их в utf-8 и пропускаем через urlencode.
    """

    def process_request(self, request):
        clean_pairs = []

        for name, value in cgi.parse_qsl(request.META['QUERY_STRING'], True):
            try:
                value.decode('utf-8')
            except UnicodeDecodeError:
                value = value.decode('cp1251', 'ignore').encode('utf-8')

            clean_pairs.append((name, value))

        clean_qs = urllib.urlencode(clean_pairs)

        # Парсим
        query_dict = QueryDict(clean_qs)

        # Формируем правильную QUERY_STRING
        request.META['QUERY_STRING'] = clean_qs
        request.GET = query_dict
