# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import absolute_import

from django.db import models
from django.utils.translation import ugettext_lazy as _


class CabinClass(models.Model):
    """ Тип класса обслуживания: economy, business"""

    code = models.CharField(verbose_name=_(u'код'), max_length=10, unique=True)

    def __repr__(self):
        return '<CabineClass id={} code={}/>'.format(self.id, self.code)

    type = 'transporttype'

    class Meta:
        verbose_name = _(u'тип класса обслуживания')
        verbose_name_plural = _(u'типы класса обслуживания')
        app_label = 'www'
        db_table = 'www_cabinclass'
