# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
import six

from django.db import models
from django.utils.translation import ugettext_lazy as _


log = logging.getLogger(__name__)


@six.python_2_unicode_compatible
class CountryCovidInfo(models.Model):
    tourism = models.NullBooleanField(verbose_name=_('Разрешён туризм'), blank=True, null=True, default=None)
    quarantine = models.NullBooleanField(verbose_name=_('Действует карантин'), blank=True, null=True, default=None)
    quarantine_days = models.IntegerField(verbose_name=_('Число дней карантина (если действует)'),
                                            blank=True, null=True, default=None)
    visa = models.NullBooleanField(verbose_name=_('Нужна виза при въезде'), blank=True, null=True, default=None)
    avia = models.NullBooleanField(verbose_name=_('Открыто авиасообщение с РФ'), blank=True, null=True, default=None)
    updated_at = models.DateTimeField(verbose_name=_('Когда обновлено'), null=True, blank=True, default=None)
    comment = models.TextField(verbose_name=_('Комментарий'), null=True, blank=True, default='')
    country = models.ForeignKey('www.Country', null=False, blank=False)

    def __str__(self):
        return '{} {} {} {} {} {}'.format(
            self.country.id,
            self.tourism,
            self.quarantine,
            self.quarantine_days,
            self.visa,
            self.avia,
        )

    class Meta:
        verbose_name = 'Информация о covid-ограничениях для туризма для страны'
        verbose_name_plural = u'Информация о covid-ограничениях для туризма по странам'
        app_label = 'www'
        db_table = 'www_covidinfo'
