# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _


class Holiday(models.Model):
    title = models.CharField(
        verbose_name=_(u'Название праздника'), max_length=256,
        null=False, blank=False, default=u''
    )

    name_tanker_key = models.CharField(
        verbose_name=_(u'Ключ в танкере для названия праздника'), max_length=256,
        null=True, blank=False, default=None
    )

    first_segment_first_day = models.DateField(
        verbose_name=_(u'Первый день первого периода'),
        null=False,
        blank=False,
    )

    first_segment_last_day = models.DateField(
        verbose_name=_(u'Последний день первого периода'),
        null=False,
        blank=False,
    )

    second_segment_first_day = models.DateField(
        verbose_name=_(u'Первый день второго периода'),
        blank=True,
        null=True,
        default=None
    )

    second_segment_last_day = models.DateField(
        verbose_name=_(u'Последний день второго периода'),
        blank=True,
        null=True,
        default=None,
    )

    is_active = models.BooleanField(
        verbose_name=_(u'Активный'),
        blank=False,
        null=False,
        default=True,
    )

    @property
    def first_day(self):
        return self.first_segment_first_day

    @property
    def last_day(self):
        return self.second_segment_last_day or self.first_segment_last_day

    def __unicode__(self):
        last_day = self.last_day
        return u'<Holiday title={} first_day={} last_day={}'.format(
            self.title,
            self.first_segment_first_day.strftime('%Y-%m-%d'),
            last_day.strftime('%Y-%m-%d'),
        )

    def save(self, *args, **kwargs):
        if not self.first_segment_first_day:
            self.first_segment_first_day = self.first_day

        if not self.first_segment_last_day:
            self.first_segment_last_day = self.last_day

        super(Holiday, self).save(*args, **kwargs)

    class Meta:
        verbose_name = _(u'праздник')
        verbose_name_plural = _(u'праздники')
        app_label = 'www'
        db_table = 'www_holiday'


class HolidayDirection(models.Model):
    holiday = models.ForeignKey(
        'Holiday',
        related_name='holiday_directions'
    )

    settlement_from = models.ForeignKey('Settlement', verbose_name=_(u'город отправления'),
                                        related_name='holiday_directions_from')

    settlement_to = models.ForeignKey('Settlement', verbose_name=_(u'город прибытия'),
                                      related_name='holiday_directions_to')

    class Meta:
        verbose_name = _(u'праздничное направление')
        verbose_name_plural = _(u'праздничные направления')
        app_label = 'www'
        db_table = 'www_holiday_direction'
