# -*- coding: utf-8 -*-
import logging
import re

from django.db import models

from travel.avia.library.python.common.utils.fields import CodeCharField, RegExpField

log = logging.getLogger(__name__)


class IataCorrection(models.Model):
    code = CodeCharField(u'Код IATA', max_length=4, blank=False)
    number = RegExpField(u'Номер рейса', max_length=1000,
                         help_text=(u'Номер без кода. Можно задавать регулярным выражением'))
    company = models.ForeignKey('www.Company', null=False, blank=False)

    def match_number(self, number):
        if not hasattr(self, '_number_re'):
            try:
                self._number_re = re.compile(self.number, re.I + re.U)
            except Exception as err:
                self._number_re = None
                log.critical(u'IataCorrection[%s][%s] compile number %r. %r',
                             self.id, self.code, self.number, err)
        return self._number_re.match(number) if self._number_re else None

    def __unicode__(self):
        return u"{} {} -> {}".format(self.code, self.number, self.company.title)

    class Meta:
        verbose_name = u'Коррекция IATA кода'
        verbose_name_plural = u'Коррекции IATA кодов'
        app_label = 'importinfo'
        db_table = 'importinfo_iatacorrection'
