# -*- coding: utf-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _


class Script(models.Model):
    """
    Модель скрипта, который можно запустить в админке под www-data
    """
    code = models.CharField(
        verbose_name=_(u"код"),
        blank=False,
        null=False,
        max_length=255,
        unique=True
    )

    description = models.CharField(
        verbose_name=_(u"описание"),
        max_length=255
    )

    command = models.CharField(
        verbose_name=_(u"команда"),
        max_length=500,
        null=True,
        default=None
    )

    timeout = models.PositiveIntegerField(
        verbose_name=_(u"максимальное время выполнения"),
        default=5000
    )

    enabled_in_development = models.BooleanField(
        verbose_name=_(u'включен в деве'),
        blank=False,
        null=False,
        default=True
    )

    enabled_in_testing = models.BooleanField(
        verbose_name=_(u'включен в тестинге'),
        blank=False,
        null=False,
        default=True
    )

    enabled_in_stress = models.BooleanField(
        verbose_name=_(u'включен для стрельб'),
        blank=False,
        null=False,
        default=False
    )

    enabled_in_production = models.BooleanField(
        verbose_name=_(u'включен в проде'),
        blank=False,
        null=False,
        default=True
    )

    def __unicode__(self):
        return self.code

    class Meta:
        app_label = 'www'
        verbose_name = _(u"скрипт")
        verbose_name_plural = _(u"скрипты")


class ScriptResult(models.Model):
    """
    Результат выполнения скрипта запущенного в админке под www-data
    """
    script = models.ForeignKey(
        Script,
        verbose_name=_(u'Результат выполнения скрипта')
    )

    success = models.BooleanField(
        verbose_name=_(u'Выполнен'),
        blank=False,
        null=False,
        default=True
    )

    started_at = models.DateTimeField(
        verbose_name=_(u'Время старта'),
        blank=False,
        null=False,
    )

    finished_at = models.DateTimeField(
        verbose_name=_(u'Время конца'),
        blank=False,
        null=True
    )

    log_file = models.CharField(
        verbose_name=_(u"Лог выполнения"),
        max_length=255,
        blank=False,
        null=False
    )

    class Meta:
        app_label = 'www'
        verbose_name = _(u"Результат выполнения скрипта")
        verbose_name_plural = _(u"Результаты выполнения скрипта")
