# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import absolute_import

from django.db import models
from django.utils.translation import ugettext_lazy as _


class Service(models.Model):
    """ Сервисы яндекса"""

    code = models.CharField(verbose_name=_(u'код'), max_length=20, unique=True)
    description = models.CharField(verbose_name=_(u'описание'), max_length=255)
    is_mobile = models.BooleanField(
        verbose_name=_(u'мобильный источник'), default=False
    )
    allow_custom_store_time = models.BooleanField(
        verbose_name=_(u'произвольное время жизни'), default=False
    )
    limited = models.BooleanField(
        verbose_name=_(u'Ограничение числа запросов'),
        default=False, null=False, blank=False
    )
    multiple = models.BooleanField(
        verbose_name=_(u'несколько сервисов с префиксом кода'), default=False,
        null=False, blank=False
    )
    team = models.ForeignKey(
        'Team',
        verbose_name=_(u'команда'),
        related_name='team_service'
    )

    def __repr__(self):
        return '<Service id={} code={} team={}/>'.format(self.id, self.code, self.team_id)

    class Meta:
        verbose_name = _(u'сервис')
        verbose_name_plural = _(u'сервисы')
        app_label = 'www'
        db_table = 'www_service'
