# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import absolute_import

from django.db import models
from django.utils.translation import ugettext_lazy as _


class Team(models.Model):
    """ Команды яндекса"""

    code = models.CharField(verbose_name=_(u'код'), max_length=10, unique=True)
    description = models.CharField(verbose_name=_(u'описание'), max_length=255)

    def __repr__(self):
        return '<Team id={} code={}/>'.format(self.id, self.code)

    class Meta:
        verbose_name = _(u'команда')
        verbose_name_plural = _(u'команды')
        app_label = 'www'
        db_table = 'www_team'
