# -*- coding: utf-8 -*-

from django.db import models


class Timestamp(models.Model):
    code = models.CharField(null=False, primary_key=True, max_length=16)
    value = models.DateTimeField(null=True)

    @classmethod
    def set(cls, code, value):
        instance = cls.objects.get(code=code)
        instance.value = value
        instance.save()

    @classmethod
    def get(cls, code):
        return cls.objects.get(code=code).value

    class Meta:
        app_label = 'www'
