# -*- coding: utf-8 -*-

import logging
from importlib import import_module

from django.conf import settings
from django.db import close_old_connections

log = logging.getLogger(__name__)


def _precache():
    try:
        log.info('Precaching...')
        precache()

    finally:
        # Закрываем все открытые соединения с базой
        close_old_connections()

    log.info("Done")


def precache():
    for call in settings.PRECACHE:
        try:
            module_name, method_name = call.split(':')
        except ValueError:
            log.error("Call string %r has no colon", call)
            continue

        module = import_module(module_name)

        method = module

        for name in method_name.split('.'):
            method = getattr(method, name)

        method()
