# -*- coding: utf-8 -*-
import os
import signal
import time

preload_app = True

RECACHE_FUNC_UID = 'travel.avia.library.python.common.precache.gunicorn.conf.recache'


def precache(server):
    """
    # Send signal to recache:
    from travel.avia.library.python.common.utils.mysql_switcher import signals as switcher_signals
    switcher_signals.data_updated.send(cls)
    """

    from travel.avia.library.python.common.precache.backend import _precache
    from travel.avia.library.python.common.utils.mysql_switcher.signals import data_updated

    server_pid = os.getpid()

    def recache(**kwargs):
        server.log.info("Data update detected, recaching")

        os.kill(server_pid, signal.SIGHUP)

    while True:
        try:
            server.log.info("Precaching...")

            data_updated.disconnect(dispatch_uid=RECACHE_FUNC_UID)

            _precache()

            data_updated.connect(recache, weak=False, dispatch_uid=RECACHE_FUNC_UID)
        except:
            server.log.exception("Unhandled exception in precache:")
            server.log.info("Retrying in 30 seconds")

            time.sleep(30)

            continue

        break

    server.log.info("Done")


def on_starting(server):
    precache(server)


def on_reload(server):
    precache(server)


def pre_fork(server, worker):
    # Закрываем соединение, чтобы не передавать воркерам копию сокета [RASPWIZARDS-175]
    from django.core.cache import cache
    cache.close()
