# -*- encoding: utf-8 -*-
import logging
import json


class QloudJsonFormatter(logging.Formatter):
    """Формат сообщений в лог для qloud в формате json"""

    def format(self, record):
        """
        :param logging.LogRecord record:
        :return: str
        """
        data = {
            'message': self._format_message(record),
            'level': record.levelname,
        }

        fields = {
            'file': {
                'path': record.pathname,
                'line': record.lineno,
                'func': record.funcName,
            },
            'loggerName': record.name,
            'module': record.module,
            'process': record.process,
            'processName': record.processName,
            'thread': record.thread,
            'threadName': record.threadName,
        }

        if record.exc_info:
            data['stackTrace'] = self.formatException(record.exc_info)

        data['@fields'] = fields

        return json.dumps(data)

    def _format_message(self, record):
        """
        :param logging.LogRecord record:
        :return: str
        """

        if self.usesTime():
            record.asctime = self.formatTime(record, self.datefmt)

        return self._fmt % record.__dict__
