# -*- coding: utf-8 -*-

import logging
SEND_MAIL_TO_PARTNERS = False

# Особенности этого проекта. Магические цифры и фразы.
DOMAIN_NAME = "rasp.yandex.ru"
# Если не указан берется просто DOMAIN_NAME
ADMIN_DOMAIN_NAME = None

NATIONAL_VERSION_COUNTRY_MAP = {
    'ru': 225,
    'tr': 983,
    'ua': 187
}

NATIONAL_CURRENCIES = {
    'ru': 'RUR',
    'ua': 'UAH',
    'tr': 'TRY',
}

MOSCOW_GEO_ID = 213
RUSSIA_GEO_ID = 225

KIEV_GEO_ID = 143
UKRAINE_GEO_ID = 187

ISTANBUL_GEO_ID = 11508
TURKEY_GEO_ID = 983


# Город по умолчанию для регионального домена. Если для регионального домена не определен город по умолчанию, то
# используется столица страны регионального домена
DEFAULT_CITIES = {
    'tr': 11508  # Стамбул
}

WEEK_DAYS = {0: u'понедельник',
             1: u'вторник',
             2: u'среда',
             3: u'четверг',
             4: u'пятница',
             5: u'суббота',
             6: u'воскресенье'}

MONTHS = {1: u'января',
          2: u'февраля',
          3: u'марта',
          4: u'апреля',
          5: u'мая',
          6: u'июня',
          7: u'июля',
          8: u'августа',
          9: u'сентября',
          10: u'октября',
          11: u'ноября',
          12: u'декабря'}

# на сколько дней назад смотреть рейсы, для www.forms.clear_dates (и зачем-то search.py)
DAYS_TO_PAST = 30


# Количество городов в поиске до страны
CITIES_IN_COUNTRY_SEARCH = 10

# Максимальная длина подсказок в поисковой форме RASP-2336
MAX_LENGTH = 25

# Погода
WEATHER_ICAO_URL = "http://export.yandex.ru/weather-ng/rasp/%s.xml"  # Погода в аэропорте
# Сервис Я.Погода для региональных доменов
WEATHER_URL = {
    'ru': "pogoda.yandex.ru",
    'ua': "pogoda.yandex.ua",
    'com.tr': "hava.yandex.com.tr",
    'by': 'pogoda.yandex.by',
    'kz': 'pogoda.yandex.kz'
}

WEATHER_DEFAULT_URL = WEATHER_URL['ru']

QUICK_HTTP_TIMEOUT = .1

# Таймаут при получении внешних данных, например геобазы
HTTP_TIMEOUT = 3
SCHEDULE_IMPORT_TIMEOUT = 600  # 10 минут

LOG_LEVEL = logging.INFO

FOTKI_API = 'https://api-fotki.yandex.ru'

# Конфиги для RSYNC
RSYNC_CONFIGS = {}
# ===============================================================================
# Пример
# claster_list = []
# RSYNC_CONFIGS = {
#    'pythonbp': (
#        [["/var/lib/yandex-rasp/rasp/www/db/scripts/export/", "rasp-export"],
#         ["/var/lib/yandex-rasp/rasp/www/db/scripts/export2/", "rasp-export2"]],
#        ["host1", "host2"]
#    )
# }
# Команды для рсинка
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export/ rsync://host1/rasp-export
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export/ rsync://host2/rasp-export
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export2/ rsync://host1/rasp-export2
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export2/ rsync://host2/rasp-export2
# ===============================================================================

CURRENCY_RATES_URL = 'http://units-converter-r1.n.yandex-team.ru/converter-rasp'
CURRENCY_RATES_TIMEOUT = .5  # полсекунды

# Счетчики (RASP-5806)
COUNTERS = {1: 70142, 2: 70141, 3: 70881, 4: 72126, 5: 72126, 6: 70208}


# Пары аэропорт - вокзал для аэроэкспрессов
AEROEXPRESSES = {
    9600215: 2000007,  # Внуково
    9600216: 2000005,  # Домодедово
    9600213: 2000006,  # Шереметьево
    9600370: 9607404,  # Кольцово
    9623592: 9618228,  # Вильнюс
}
AEROEXPRESSES.update(dict((station_to, station_from) for station_from, station_to in AEROEXPRESSES.items()))

UNITTEST = False

TICKET_ORDER_LINK = "http://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70831/*http://%s/order/?showCheaper=t&%s"
TICKET_VARIANTS_LINK = "http://%s/variants/?%s"

INTERVAL_RTHREAD_TYPE_ID = 12

ADMIN_COUNTRY_YMAPLANGUAGE_MAP = {
    'RU': 'ru-RU',
    'TR': 'tr-TR',
    'UA': 'uk-UA',
}

TOO_MUCH_STATIONS = 500

SPECIAL_OFFERS_TRAVEL_URL = 'http://go.poedem.ru/?t=poedem&f=xml&a=special_offers&date='

SPACE_RASPADMIN_SHARE = 'space.rasp.yandex.net::raspadmin'

POPULAR_DIRECTIONS_IMPORT_PROXY = 'smith.yt.yandex.net'
