# -*- coding: utf-8 -*-
# Django settings for rasp project.
from travel.avia.library.python.common.utils.dcutils import dc_cache
import re

# @UnusedImport fix for UserWarning: Module _mysql was already imported from
import pytz  # noqa

import os
import time
import datetime
import socket

from django.utils.translation import ugettext_lazy as _


ENVIRONMENT = 'production'

EMAIL_HOST = 'localhost'
EMAIL_SUBJECT_PREFIX = '[Django-rasp@%s] ' % socket.gethostname()
DEFAULT_FROM_EMAIL = 'rasp-tech@yandex-team.ru'
SERVER_EMAIL = 'Rasp at %s <rasp-tech@yandex-team.ru>' % socket.gethostname()

DEBUG = False
TEMPLATE_DEBUG = False
ORDER_DEBUG = False
TIMING = False

ENABLE_TRACER = False

DEBUG_PROPAGATE_EXCEPTIONS = False

DEBUG_BEMJSON = False

SHOW_TRANSFER_PRICES = False

try:
    import pwd
    current_user = ('Current User', '%s@yandex-team.ru' % pwd.getpwuid(os.getuid())[0])
except Exception:
    username = os.environ.get('USERNAME', os.environ.get('LOGNAME'))
    if username:
        current_user = ('Current User', '%s@yandex-team.ru' % username)
    else:
        current_user = ('Current User', 'none')

CURRENT_USER_NAME = current_user[1]

TESTERS = MANAGERS = ADMINS = (current_user, )
DATACHANGE_RCPNTS = PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
EXPERSS_SUBST_RCPNTS = UNKNOWN_CODES_RCPNTS = RASP_FREE_STATIONS_RCPNTS = ADMINS

ERRORS_RECIPIENTS = [current_user[1]]


class WorkInstance(object):
    db_alias = 'work_db'
    code = 'work'
    title = u'боевой'


class ServiceInstance(object):
    db_alias = 'service_db'
    code = 'service'
    title = u'сервисный'


class MigrationInstance(object):
    db_alias = 'migration_db'
    code = 'migration'
    title = u'миграционный'


INSTANCE_ROLE = WorkInstance

THREAD_SHARED_CONNECTION = False

BILLING_HOST = 'mbi1ft.yandex.ru'  # хост биллинга
BILLING_PORT = 34861             # порт
BILLING_SERVICE_ID = 114         # номер нашего сервиса в биллинге


CACHES = {
    'default': dc_cache(['localhost']),
}

FORCE_SCRIPT_NAME = ""

# Local time zone for this installation. Choices can be found here:
# http://www.postgresql.org/docs/8.1/static/datetime-keywords.html#DATETIME-TIMEZONE-SET-TABLE
# although not all variations may be possible on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 0

# Время сервера относительно Москвы
TIME_ZONE_HOURS = 0

SITE_ID = 1
TURKISH_SITE_ID = 2

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Для нормальной работы админки
USE_L10N = True

DEFAULT_FILE_STORAGE = "travel.avia.library.python.common.utils.fields.TransliteratingFileSystemStorage"

# Make this unique, and don't share it with anybody.
SECRET_KEY = '6sm82tff48ajyfl6l+zwv4hbjp%8@iyynp*g6kn^mvb5ikdf5e'

WIZARD_MIDDLEWARE = (
    'www.middleware.MiddlewareTimingOuter',
    'www.middleware.MiddlewareTimingInner',
)

FRONTEND_MIDDLEWARE = (
    'www.middleware.RequestActivator',
    'www.middleware.MiddlewareTimingOuter',
    'www.middleware.JSONPWrapException',
    'www.middleware.AdminCsrfViewMiddleware',
    'www.middleware.Now',
    'django.middleware.gzip.GZipMiddleware',
    'www.middleware.TurnOffCache',
    'www.middleware.URLEncodingHack',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'www.middleware.Host',
    'www.middleware.YandexAuthExport',
    'www.middleware.YandexAuth',
    'www.middleware.YandexuidCookieValidate',
    'travel.avia.library.python.common.middleware.locale.Locale',
    'www.middleware.Language',
    'www.middleware.AdminAuth',
    'www.middleware.AdminSession',
    'mobile.middleware.MobileDetect',
    'mobile.middleware.MobileRedirect',
    'geotargeting.middleware.GeoTargeting',
    'travel.avia.library.python.common.middleware.mysql_error_handler.MysqlErrorHandler',
    'www.middleware.UserErrorHandler',
    'www.middleware.CheckYandexSpider',
    'www.middleware.WizardMark',
    'www.middleware.MiddlewareTimingInner',
)

ADMIN_MIDDLEWARE = FRONTEND_MIDDLEWARE + (
    'admin.middleware.on_switch_db.CustomMessageInAdminOn500WhenSwitchDB',
)

MIDDLEWARE_CLASSES = ADMIN_MIDDLEWARE

MIDDLEWARE_SELECTOR = ((  # Api, export, etc
    {'path': re.compile(r'''^(?:
                        /api/.*|
                        /knobs/.*|
                        /export/.*
                        )''', re.X)},
    {'exclude': [
        'www.middleware.Language',
        'www.middleware.YandexAuth'
    ]}
), (  # Admin
    {'path': re.compile(r'/admin.*')},
    {}
), (  # Default
    {},
    {'exclude': [
        'admin.middleware.on_switch_db.CustomMessageInAdminOn500WhenSwitchDB',
    ]}
))


ROOT_URLCONF = 'urls'

INSTALLED_APPS = (
    'django_russian',
    'django_tune',
    'django_tanker',
    # Сторонние приложения
    'pytils',
    'raven.contrib.django.raven_compat',
    # Локальные приложения
    'travel.avia.library.python.common',
    'travel.avia.library.python.common.importinfo',
    'travel.avia.library.python.common.geotargeting',
    'travel.avia.library.python.common.xgettext',
    # Чтобы работали переопределения шаблонов, django нужно включать позже
    'django_yauth',
    'django.contrib.auth',
    'django.contrib.admin',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
)

FRONTEND_APPS_EXCLUDE = set([
    'django.contrib.auth',
    'django.contrib.admin',
    'travel.avia.library.python.common.importinfo',
])

assert FRONTEND_APPS_EXCLUDE.issubset(INSTALLED_APPS)

FRONTEND_APPS = [app for app in INSTALLED_APPS if app not in FRONTEND_APPS_EXCLUDE]

# None, т.е. по умолчанию закешированные результаты
# разных запросов хранятся в памяти вечно (см. /utils/cursors/..)
DEF_MYSQL_REQUEST_EXPIRE_TIME = None

LOGIN_URL = '/admin/'

try:
    from django_yauth.settings import *  # noqa
    YAUTH_USE_NATIVE_USER = True

    YAUTH_TYPE = 'intranet'
    YAUTH_BACKEND = 'blackbox'

    import blackbox

    BETA_FIELD = ('subscription.suid.668', 'beta_tester')

    YAUTH_PASSPORT_FIELDS = [blackbox.FIELD_LOGIN, BETA_FIELD]
except ImportError:
    pass

PKG_VERSION = datetime.datetime.today().strftime('dev.%Y%m%d')

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".

STATIC_URL = '/static/'

# Штамп для кэша (чтобы браузеры грузили обновленный citysuggets.js).
# Обновляется во www.views.change_db
CACHE_TIMESTAMP = time.strftime('%Y%m%d%H%M%S')

CACHEROOT = '/yandex/avia/%s/' % PKG_VERSION

PRECACHE = []

RSYNC = '/usr/bin/rsync'

PATHFINDER_TIMEOUT = .5

PATHFINDER_URL = 'http://targetpathfinder.rasp.yandex.net/search'

FILE_UPLOAD_PERMISSIONS = 0644

MAPPING_SERVER_EXPIRE = 20  # минут
MAPPING_CLIENT_EXPIRE = 5  # минут

LANGUAGE_COOKIE_NAME = 'lang'

DEBUG_I18N = False

DISABLE_YAUTH = False
DISABLE_PHD = False

MORDA_HOSTS = ['localhost']

MAIL_REPORTS_INTERVAL = 600

# Настройки танкера

# Токен для @robot-avia-api-pilot
TANKER_TOKEN = 'Oauth AQAD-qJSJmfPAAAGzKG7kpCbT0wEqDHSmNwBaSk'

TANKER_KEYSETS = {}

XGETTEXT_KEYSETS = {
    'common': {
        'filename': 'travel/avia/library/python/common/xgettext/keyset.json',
        'dirs': [
            'common/models',
            'common/utils',
            'common/views',
        ]
    }
}

XGETTEXT_RELOAD_KEYSETS = False

# Для загрузки кейсетов
# Сразу грузим побольше языков, т.к. в дальнейшем будем на них переводить
XGETTEXT_LANGUAGES = ['en', 'ru', 'uk', 'be', 'tt', 'kk', 'tr']

# (path, prefix, blocks)
XGETTEXT_BEM_BLOCKS = []

# Настройки языков расписаний. Ставит в соответствие домену основной язык приложения (используемый по умолчанию)
# и список языков доступных для смены
DOMAIN_LANGUAGE_MAP = {
    'ru': ('ru', ['ru']),
    'tr': ('tr', ['tr']),
    'ua': ('uk', ['uk', 'ru']),
}

DOMAIN_TO_NATIONAL_VERSION = {
    'ru': 'ru',
    'ua': 'ua',
    'tr': 'tr',
}

NATIONAL_VERSION_TO_METRIKA = {
    'ru': 99704,
    'tr': 21395248,
    'ua': 23220169,
}

NATIONAL_VERSION_DEFAULT_SEARCH_CITIES = {
    'ru': (213, 2),  # Москва - Питер
    'tr': (11508, 11503),  # Стамбул - Анкара
    'ua': (143, 144),  # Киев - Львов
}

# Список root domains на которых показывается Яндекс.Директ
DIRECT_DOMAINS = ['ru', 'ua', 'by', 'kz']

MODEL_LANGUAGES = ['ru', 'en', 'tr', 'uk']  # Добавлен английский, fallback для турецких названий

SUGGEST_LANGUAGES = ['ru', 'tr', 'uk', 'en']

SUGGEST_URL = 'https://suggest.rasp.yandex.net/'

# Языки для которых у нас есть отображение, возможно стоит
# объединить с DOMAIN_LANGUAGE_MAP, FRONTEND_LANGUAGES
FRONTEND_LANGUAGES = ['ru', 'tr', 'uk']

LANGUAGES = [
    ('ru', _(u'Русский')),
    ('be', _(u'Белорусский')),
    ('kk', _(u'Казахский')),
    ('tt', _(u'Татарский')),
    ('uk', _(u'Украинский')),
    ('en', _(u'Английский')),
    ('tr', _(u'Турецкий'))
]

LANGUAGE_FALLBACKS = {
    'tr': ['en'],
    'uk': ['ru'],
    'de': ['en'],
    'kk': ['ru'],
    'be': ['ru'],
}

LANGUAGE_CASE_FALLBACKS = {
    ('uk', 'genitive'): [('ru', 'genitive')],
}

# Джанговские настройки для языков
# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'ru'

BASE_LANGUAGE = 'ru'

WIZARD_MODE = False

CLEAN_TMP = True

TIME_CORRECTION_URL = '/time/correction/'

TICKET_HOST = 'avia.yandex.ru'
TICKET_URL = 'https://avia.yandex.ru/'

LOG_COLLECT_RESULTS = False

PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), '../..'))

try:
    SUBMODULE_STATUS = open(
        os.path.join(PROJECT_PATH, 'submodule-status')
    ).read()
except IOError:
    SUBMODULE_STATUS = 'no submodule-status'

SECRET_SALT = 'b1818c0846d2bb22b30e17b6dbd678be'

HAS_VALID_YANDEXUID_ALWAYS_TRUE = False

GEOTARGETING_EXCLUDE_PREFIXES = ('/api/', '/admin/', '/export/', '/-/', '/jsi18n/')
GEOTARGETING_INCLUDE_PREFIXES = ('/api/tickets/redirect/', '/api/suburban/next_trains/')
GEOTARGETING_DISABLE_REDIRECT_PREFIXES = GEOTARGETING_EXCLUDE_PREFIXES

LANGDETECTSERVER_URL = 'http://localhost:8111/'

SUPPORTED_HOSTS = []

BLACKBOX_URL = 'http://blackbox-mimino.yandex.net/blackbox'

BLACKBOX_PROJECT_FIELDS = []

# функция check_language почему-то ищет не в той директории .mo файлы,
# поэтому добавляем путь, где они реально лежат в virtualenv
LOCALE_PATHS = [os.path.join(os.path.dirname(__file__), '..', 'virtualenv', 'django', 'conf', 'locale')]

# https://wiki.yandex-team.ru/maps/dev/core/snippeter/api/#zapros
GEO_SNIPPETER_URL = 'http://snippetter01h.tst.maps.yandex.ru'

LOAD_DB_BASE_URL = 'https://admin.rasp.yandex-team.ru/admin/files/'
LOAD_DB_EXCLUDE_TABLES = ('importinfo_originalthreaddata',)

GUNICORN_PIDFILE = None

WIZARD_FORBIDDEN_PARTNERS = {'biletdv', 'chabooka', 'kupibilet', 'onetwotrip', 'biletix'}
