# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from travel.avia.library.python.common.utils.dcutils import dc_cache

nothing = object()


def get_caches_config_by_group(conductor_group, conductor, suitable_dc=None):
    caches = dict(
        (dc, dc_cache(['inet6:[%s]' % h for h in hosts]))
        for dc, hosts in conductor.get_group_hosts_by_dc(conductor_group).items()
    )

    if suitable_dc is None:
        suitable_dc = conductor.get_current_dc()

    if suitable_dc == 'myt' and suitable_dc not in caches:
        suitable_dc = 'iva'

    caches['default'] = caches.pop(suitable_dc)

    return caches


def define_setting(name, env=None, default=nothing, converter=lambda x: x):
    """
    Объявляем настройку name.
    Настройка будет доступна на django.conf.settings.
    Значения по умолчанию можно переопределить, если положить настройку в setting до define,
    например в local_settings.
    """
    from django.conf import settings

    def _set_setting(name, value):
        # Если настройки переопределены, то добавляем нашу настройку в корневой setting
        # Такое может случиться если define прошел в контексте override_settings
        # Так же могут быть вложенные override_settings
        target_settings = settings
        while hasattr(target_settings, 'default_settings'):
            target_settings = target_settings.default_settings
        setattr(target_settings, name, value)

    if os.environ.get('AVIA_' + name) is not None:
        value = converter(os.environ.get('AVIA_' + name))
        _set_setting(name, value)
        return

    if getattr(settings, name, nothing) is not nothing:
        return

    applied_config = getattr(settings, 'APPLIED_CONFIG', None)
    if env and applied_config in env:
        default = env[applied_config]

    assert default is not nothing

    _set_setting(name, default)
