PY2_LIBRARY(tests)

OWNER(g:avia)

PEERDIR(
    contrib/python/freezegun
    contrib/python/mock
    contrib/python/MySQL-python
    contrib/python/requests-mock

    travel/avia/library/python/common
    travel/avia/library/python/tester

    travel/rasp/library/python/hemi
)

PY_SRCS(
    config/conftest.py
    tests_settings.py
)

TEST_SRCS(
    __init__.py
    cache/__init__.py
    cache/test_price_list.py
    importinfo/__init__.py
    importinfo/models/__init__.py
    lib/__init__.py
    lib/test_company_finder.py
    lib/test_holiday_search_date_provider.py
    middleware/__init__.py
    middleware/test_geotargeting.py
    middleware/test_ip.py
    middleware/test_locale_request.py
    middleware/test_mda.py
    middleware/test_national_redirect.py
    middleware/test_tune.py
    middleware/test_tune_redirect.py
    middleware/test_uatraits_detector.py
    models/__init__.py
    models/currency/__init__.py
    models/currency/test_format_value_negative.py
    models/currency/test_format_value_negative_usd.py
    models/currency/test_format_value_positive.py
    models/currency/test_format_value_tr.py
    models/currency/test_ordering.py
    models/geo/__init__.py
    models/geo/test_point.py
    models/geo/test_settlement.py
    models/geo/test_station.py
    models/geo/test_time_zone_mixin.py
    models/models_utils/__init__.py
    models/models_utils/test_hidden_manager.py
    models/partner/test_partner.py
    models/partner/test_update_unavailability_rule.py
    models/rthread/__init__.py
    models/rthread/test_schedule_appendix.py
    models/schedule/__init__.py
    models/schedule/test_company_slug.py
    models/schedule/test_rtstation_calc_days_shift.py
    models/schedule/test_sale_url_formatter.py
    models/schedule/test_string_template_validator.py
    models/schedule/test_supplier_sale_enabled.py
    models/schedule/test_train_schedule_plan.py
    models/settlement/__init__.py
    models/settlement/test_settlement_full_geography.py
    models/settlement/test_settlement_title_phrase_from.py
    models/settlement/test_settlement_title_phrase_to.py
    models/utils/__init__.py
    models/utils/test_fetch.py
    precache/__init__.py
    precache/test_precache_manager.py
    settings/__init__.py
    settings/test_utils.py
    utils/__init__.py
    utils/currency_converter/__init__.py
    utils/currency_converter/test_converter_cache_build.py
    utils/currency_converter/test_converter_cache_load.py
    utils/currency_converter/test_converter_cache_save.py
    utils/django_utils/__init__.py
    utils/django_utils/test_utf8_json_serializer.py
    utils/test_antirobot.py
    utils/test_bemhtml_template.py
    utils/test_caching.py
    utils/test_date.py
    utils/test_geosnippetter.py
    utils/test_httpcaching.py
    utils/test_iterrecipes.py
    utils/test_lxmlutils.py
    utils/test_marketstat.py
    utils/test_settlement_ymap_url.py
    utils/test_title_generator.py
)

NO_CHECK_IMPORTS()

END()

RECURSE_FOR_TESTS(
    py2
)
