# -*- coding: utf-8 -*-

import json
from collections import OrderedDict

from django.core.serializers import json as json_serializer
from django.utils.encoding import force_text


class Serializer(json_serializer.Serializer):
    def get_dump_object(self, obj):
        data = OrderedDict((
            ('model', force_text(obj._meta)),
        ))
        if not self.use_natural_primary_keys or not hasattr(obj, 'natural_key'):
            data["pk"] = force_text(obj._get_pk_val(), strings_only=True)

        data['fields'] = self._current

        return data

    def end_object(self, obj):
        # self._current has the field data
        indent = self.options.get("indent")
        if not self.first:
            self.stream.write(",")
            if not indent:
                self.stream.write(" ")
        if indent:
            self.stream.write("\n")

        self.json_kwargs.setdefault('cls', json_serializer.DjangoJSONEncoder)
        data = force_text(json.dumps(self.get_dump_object(obj), ensure_ascii=False, **self.json_kwargs))
        self.stream.write(data)
        self._current = None


Deserializer = json_serializer.Deserializer
