# -*- coding: utf-8 -*-


def fix_rollback_on_exception():
    """
    Ловим OperationalError в rollback_on_exception
    RASP-15715
    """

    from MySQLdb import OperationalError

    from django import db
    from django.db.utils import DatabaseError
    # from django.core import signals

    # signals.got_request_exception.disconnect(db._rollback_on_exception)

    def _rollback_on_exception(**kwargs):
        for conn in db.connections:
            try:
                db.transaction.rollback_unless_managed(using=conn)
            except (DatabaseError, OperationalError):
                pass

    # signals.got_request_exception.connect(_rollback_on_exception, weak=False)
