# -*- coding: utf-8 -*-

import time
from datetime import datetime
from threading import local

import pytz

from django.conf import settings
from django.utils.translation import get_language


def today():
    return now().date()


def now():
    # Берем из запроса, если уже установлено
    rq = get_request()
    if rq and getattr(rq, 'naive_msk_now', None):
        return rq.naive_msk_now

    return ultimate_now()


def unixtime():
    return int(time.time())


def ultimate_now():
    """
    На случай, если время начала запроса будет не достаточно
    """

    return now_aware().replace(tzinfo=None)


def now_aware():
    from .date import MSK_TZ

    env_now = getattr(settings, 'ENVIRONMENT_NOW', None)

    if env_now is not None:
        return MSK_TZ.localize(env_now)

    return pytz.UTC.localize(datetime.utcnow()).astimezone(MSK_TZ)


def get_locale():
    request = get_request()

    return u"%s_%s" % (get_language(), request.NATIONAL_VERSION.upper()) if request else get_language()


_active = local()


def get_request():
    return getattr(_active, "value", None)


def activate_request(request):
    _active.value = request


def deactivate_request():
    if hasattr(_active, "value"):
        del _active.value
