# -*- coding: UTF-8 -*-

import urlparse

import requests
from django.core.files.storage import Storage
from django.conf import settings
from django.utils.deconstruct import deconstructible


@deconstructible
class YFStorage(Storage):
    def __init__(self, token, user, album):
        self.token = token
        self.user = user
        self.album = album

    def add_image_url(self):
        path = '/api/users/{user}/album/{album}/photos/'.format(user=self.user, album=self.album)

        return urlparse.urljoin(settings.FOTKI_API, path)

    def _open(self, name, mode='rb'):
        pass

    def _save(self, name, content):

        headers = {
            'Authorization': 'OAuth %s' % self.token,
            'Accept': 'application/json'
        }

        data = {
            'disable_comments': 'true',
            'access_type': 'public',
            'hide_original': 'false',
        }

        files = {'image': content.read()}

        response_json = requests.post(self.add_image_url(), headers=headers, data=data, files=files).json()

        return response_json['links']['editMedia']

    def delete(self, name):
        pass

    def listdir(self, path):
        pass

    def size(self, name):
        pass

    def exists(self, name):
        pass

    def url(self, name):
        return name
