# -*- coding: utf-8 -*-

from django import forms
from django.utils.deconstruct import deconstructible
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.utils.safe_xml_parser import safe_parse_xml


@deconstructible
class FileSizeValidator(object):
    def __init__(self, size_limit_in_bytes):
        self.size_limit_in_bytes = size_limit_in_bytes

    def __call__(self, image):
        if len(image) > self.size_limit_in_bytes:
            raise forms.ValidationError(
                _(u'Файл %s превышает допустимый лимит %.2f МБ')
                % (image.name, self.size_limit_in_bytes / 1024. / 1024.)
            )

    # Нужно, чтобы джанга не дублировала миграции
    def __eq__(self, other):
        return True


@deconstructible
class SvgValidator(object):
    def __call__(self, data):
        try:
            safe_parse_xml(data.file)
        except IOError:
            raise forms.ValidationError(_(u'Файл не найден %s') % data.name)
        except Exception:
            raise forms.ValidationError(_(u'Формат файла не поддерживается'))

    # Нужно, чтобы джанга не дублировала миграции
    def __eq__(self, other):
        return True
