# -*- coding: utf-8 -*-
from importlib import import_module

import inspect
import os.path
from shutil import rmtree


def remove_tmp_dir(temporary_directory):
    if os.path.exists(temporary_directory):
        rmtree(temporary_directory)


def get_relative_path(path, base_path):
    path = os.path.abspath(path)
    base_path = os.path.abspath(base_path)
    return path.replace(base_path, "", 1).lstrip('/') if path.startswith(base_path) else path


def get_project_relative_path(path):
    from django.conf import settings

    return get_relative_path(path, settings.PROJECT_PATH)


def get_class_script_path(cls):
    """
    Получем путь к файлу, содержащему класс, если не получилось, возвращаем имя модуля.
    """
    try:
        module = import_module(cls.__module__)
    except ImportError:
        return cls.__module__

    if hasattr(module, '__file__'):
        return get_project_relative_path(module.__file__)
    else:
        return cls.__module__


def get_my_caller_file(stack):
    caller_frame = stack[1]
    filename = caller_frame[1]
    return filename


def get_current_file_dir():
    stack = inspect.stack()
    caller_file_path = get_my_caller_file(stack)

    caller_file_name = os.path.basename(caller_file_path)

    name, _ext = os.path.splitext(caller_file_name)

    return os.path.dirname(os.path.normpath(os.path.abspath(caller_file_path)))


def get_current_file_data_dir():
    stack = inspect.stack()
    caller_file_path = get_my_caller_file(stack)

    caller_file_name = os.path.basename(caller_file_path)

    name, _ext = os.path.splitext(caller_file_name)

    dir_name = os.path.dirname(os.path.normpath(os.path.abspath(caller_file_path)))

    if name == '__init__':
        return os.path.join(dir_name, 'data')
    else:
        return os.path.join(dir_name, 'data', name)
