# -*- coding: utf-8 -*-

import logging
import time
import urllib2


log = logging.getLogger(__name__)


def urlopen(*args, **kwargs):
    if 'timeout' not in kwargs:
        # Импортируем здесь, чтобы можно было использовать функцию без инициализации джанги
        from django.conf import settings
        kwargs['timeout'] = settings.HTTP_TIMEOUT

    start = time.time()

    try:
        return urllib2.urlopen(*args, **kwargs)
    finally:
        duration = time.time() - start

        try:
            log.debug('%.2f ms: urlopen(*%r, **%r)' % (duration * 1000, args, kwargs))
        except Exception:
            pass


def quick_urlopen(*args, **kwargs):
    from django.conf import settings

    kwargs['timeout'] = settings.QUICK_HTTP_TIMEOUT

    return urlopen(*args, **kwargs)
