# -*- coding: utf-8 -*-

import urlparse

from django.core.urlresolvers import reverse
from django.http import QueryDict
from django.utils.http import urlencode


ONE_SHOT_PARAMS = ['noDirect']


# DEPRECATED, use composeurl
def url(view_name, *args, **kwargs):
    return composeurl(view_name, args=args, kwargs=kwargs)


# DEPRECATED, don't use positionals
class Positional(object):
    def __init__(self,  index, value):
        self.index = index
        self.value = value

    @classmethod
    def get(cls, request_get, name, index):
        try:
            return request_get.getlist(name)[index]
        except IndexError:
            return None


# DEPRECATED, use urlencode or change_params
def get_params(query_dict=None, escape=True, **params):
    """
    Параметры со значением None удаляются из исходных (если они там есть)
    """
    if query_dict:
        new_params = query_dict.copy()
        for param in ONE_SHOT_PARAMS:
            if param in new_params:
                del new_params[param]
    else:
        new_params = QueryDict(None, mutable=True)

    for name, value in params.items():
        if value is None:
            if name in new_params:
                del(new_params[name])
        elif isinstance(value, Positional):
            values = new_params.getlist(name)

            # Удлинняем массив, если в него не входит нужный индекс
            if len(values) < value.index + 1:
                values.extend([''] * (value.index + 1 - len(values)))

            values[value.index] = value.value
            new_params.setlist(name, values)
        elif isinstance(value, list):
            new_params.setlist(name, value)
        elif value is not False:
            new_params[name] = value

    query_string = new_params.urlencode()

    if escape:
        query_string = query_string.replace('&', '&amp;')

    return '?' + query_string


def composeurl(view_name, args=[], kwargs={}, params={}, query=''):
    path = reverse(view_name, args=args, kwargs=kwargs)

    if not query:
        query = urlencode(params, doseq=True)

    return urlparse.SplitResult('', '', path, query, '').geturl()


def change_params(query_dict, params, path=''):
    new_params = query_dict.copy()

    for name, value in params.items():
        if value is None:
            if name in new_params:
                del(new_params[name])
        elif isinstance(value, list):
            new_params.setlist(name, value)
        else:
            new_params[name] = value

    query = new_params.urlencode()

    return urlparse.SplitResult('', '', path, query, '').geturl()


class ChoiceResult(object):
    def __init__(self, choice, default):
        self.choice = choice
        # default значение было выбрано по умолчанию
        self.default = default


def get_choice(query_dict, name, choices):
    """
    Выбирает вариант в зависимости от параметра в query_dict.
    Выставляет признак default, если вариант был выбран по умолчанию.
    """

    query_code = query_dict.get(name)

    if not len(choices):
        return ChoiceResult(None, False)

    for choice in choices:
        if query_code == choice.code:
            return ChoiceResult(choice, False)

    return ChoiceResult(choices[0], True)
