# -*- coding: utf-8 -*-

from __future__ import unicode_literals


class SubTagNotFound(Exception):
    pass


_not_specified = object()


def get_sub_tag_text(el, subtag_name, default=_not_specified, nsmap=None,
                     if_not_found=_not_specified, if_text_is_empty=_not_specified):
    """
    Возвращает содержимое дочернего элемента
        <a>
          <b>asdf</b>
        </a>
        get_sub_tag_text(a_el, 'b') == 'asdf'
    """
    if default is not _not_specified:
        if_not_found = default
        if_text_is_empty = default

    subtag = el.find('./' + subtag_name, nsmap)
    if subtag is None:
        if if_not_found is _not_specified:
            raise SubTagNotFound('Subtag {} not found in tag {}'.format(subtag_name, el.tag))
        else:
            return if_not_found

    if if_text_is_empty is _not_specified:
        return subtag.text

    return if_text_is_empty if subtag.text is None else subtag.text
