# -*- coding: utf-8 -*-

# Обертка Яндекс.Детектор
import socket
import urllib2

from django.utils.http import urlencode
from lxml import etree

from travel.avia.library.python.common.utils.http import quick_urlopen


DETECTOR_HEADERS = ('profile', 'wap-profile', 'x-wap-profile', 'user-agent', 'x-operamini-phone-ua')


class InfoError(Exception):
    pass


def detect(request):
    params = {}

    for header in DETECTOR_HEADERS:
        meta_name = 'HTTP_%s' % header.upper().replace('-', '_')
        content = request.META.get(meta_name)

        if content:
            params[header] = content

    url = u'http://phd.yandex.net/detect?%s' % urlencode(params)

    try:
        response = quick_urlopen(url)

        tree = etree.parse(response)

    except (urllib2.URLError, socket.timeout):
        raise InfoError('Cannot get detector data')

    if tree.getroot().tag == 'yandex-mobile-info-error':
        raise InfoError(tree.getroot().text)

    return {
        'device-class': tree.xpath('//device-class')[0].text,
        'canring': False,
    }


def test():
    from django.http import HttpRequest

    request = HttpRequest()

    request.META = {
        'HTTP_USER_AGENT': 'Alcatel-CTH3/1.0 UP.Browser/6.2.ALCATEL MMP/1.0',
        'HTTP_WAP_PROFILE': 'http://www-ccpp-mpd.alcatel.com/files/ALCATEL-CTH3_MMS10_1.0.rdf',
    }

    print detect(request)
