# -*- coding: utf-8 -*-

import logging
import os.path
import sys
import traceback
from importlib import import_module

from django.conf import settings
from django.db.models import base


log = logging.getLogger(__name__)


class SwapModel(base.ModelBase):
    def __new__(cls, name, bases, attrs):
        # Хак для django.db.models.query_utils::deferred_class_factory:245
        if bases and name.startswith(u'{}_Deferred_'.format(bases[0].__name__)):
            admin_module_path = bases[0].admin_module_path
        else:
            admin_module_path = attrs['admin_module_path']

        if getattr(settings, 'RASP_PROJECT', None) == 'admin':
            try:
                module = import_module(admin_module_path)
            except ImportError as e:
                raise Exception('Can not import {}: {}\n{}'.format(admin_module_path, str(e), traceback.format_exc()))
            else:
                return getattr(module, name)

        return super(SwapModel, cls).__new__(cls, name, bases, attrs)


def is_the_same_module(module_name1, module_name2):
    fname1 = os.path.abspath(sys.modules[module_name1].__file__)
    fname2 = os.path.abspath(sys.modules[module_name2].__file__)

    return fname1 == fname2


def get_app_label(name, bases, attrs):
    module = attrs['__module__']

    # Не совсем верно, но в большинстве случаев мета будет по иерархии лежать где нужно.
    # А базовый класс содержаний мету может быть только один.
    base_meta = None
    for b in bases:
        if hasattr(b, '_meta'):
            base_meta = b._meta
            break

        if hasattr(b, 'Meta'):
            base_meta = b.Meta
            break

    attr_meta = attrs.get('Meta', None)

    app_label = getattr(attr_meta, 'app_label',
                        getattr(base_meta, 'app_label', None))

    if not app_label:
        # Figure out the app_label by looking one level up.
        # For 'django.contrib.sites.models', this would be 'sites'.
        model_module = sys.modules[module]
        app_label = model_module.__name__.split('.')[-2]

    return app_label
