# -*- coding: utf-8 -*-

import lxml
from lxml.html import builder as E
from django.http import HttpResponse


class PostRedirect(HttpResponse):
    def __init__(self, location, params):
        self.location = location
        self.params = params

        HttpResponse.__init__(self, self.FormWrapper(self))

    class FormWrapper(object):
        def __init__(self, redirect):
            self.redirect = redirect

        def __iter__(self):
            html = E.HTML(
                E.BODY(
                    E.FORM(
                        dict(action=self.redirect.location, method="POST"),
                        *[E.INPUT(type="hidden", name=name, value=value) for name, value in self.redirect.params.items()]
                    ),
                    E.SCRIPT(dict(type="text/javascript"), "document.forms[0].submit()")
                )
            )

            return iter(lxml.html.tostring(html))
