# -*- coding: utf-8 -*-

import re


class RegExpSet(object):
    u"""Неизменяемый объект множество. Проверяет соответствует ли данная строка
    какиму-либо из регулярных выражений указанных при создании множества.
    Как для паттернов так и для проверяемых строк желательно использовать
    unicode"""

    def __init__(self, str_list):
        self._str_list = str_list
        self._re_list = [re.compile(pattern, re.U) for pattern in str_list]
        self._yes_cache_set = set()
        self._no_cache_set = set()

    def __contains__(self, elem):
        if elem in self._yes_cache_set:
            return True
        if elem in self._no_cache_set:
            return False
        for pattern in self._re_list:
            match = pattern.match(elem)
            if match and match.group() == elem:
                self._yes_cache_set.add(elem)
                return True
        self._no_cache_set.add(elem)
        return False


class RegExpDict(object):
    u"""
    На вход принимает словарь вида {regexp1 -> value1, regexp2 -> value2,}
    Используется regexp_dict[string] - возвращает значение
    valueN, если строка(string) удовлетворяет regexpN.
    Если строка не удовлетворяет ни одному регэкспу, то возвращает None.
    """

    def __init__(self, pattern_dict):
        self._pattern_dict = pattern_dict
        self._re_dict = dict((pattern, re.compile(pattern, re.U))
                             for pattern in pattern_dict.iterkeys())

    def __getitem__(self, number):
        for pattern, regexp in self._re_dict.iteritems():
            match = regexp.match(number)

            if match and match.group() == number:
                return self._pattern_dict[pattern]

        return None
