from django.conf import settings
from django.core.cache import caches


class CacheStateStore(object):
    def __init__(self, settings_dict):
        self._dead_timeout = settings_dict.get('DEAD_TIMEOUT', 60)
        self.cache = caches['replica_set']

    @staticmethod
    def _dead_key(replica):
        return settings.CACHEROOT + 'replicastatestore/dead/%s' % replica.host

    def is_alive(self, replica):
        return self._dead_key(replica) not in self.cache

    def set_error(self, replica, e):
        self.cache.set(self._dead_key(replica), True, self._dead_timeout)


def get(settings_dict):
    return CacheStateStore(settings_dict)
