# -*- coding: utf-8 -*-
from urllib import quote_plus
from django.utils.http import urlencode

YMAP_BASE_URLS = {
    'ru': 'https://maps.yandex.ru',
    'ua': 'https://maps.yandex.ua'
}


def get_ymap_url(settlement, national_version=None, lang=None):
    """
    Получает URL для сервиса Yandex.Maps, по которому будет открыта карта с данным населенным пунктом.
    1. Если у населенный пункта есть ссылка на геобазу, то результат будет в формате /213/moscow/
    2. Если ссылки на геобазу нет, то результат будет в формате /?text=Волоколамск, Волоколамский район, Московская область, Россия
    Во втором случае значение GET-параметра text вычисляется с учетом национальной версии (нужна для спорных территорий) и языка.
    """

    base_url_ru = YMAP_BASE_URLS['ru']
    base_url = YMAP_BASE_URLS.get(national_version, base_url_ru) if national_version else base_url_ru

    geobase_region = settlement.get_geobase_region()
    if geobase_region and geobase_region.ename:
        geobase_name = quote_plus(geobase_region.ename.replace(' ', '-').lower())
        return u'{}/{}/{}/'.format(base_url, geobase_region.id, geobase_name)

    query = {
        'text': settlement.L_title_with_full_geography(national_version, lang)
    }
    return u'{}/?{}'.format(base_url, urlencode(query))
