# -*- coding: utf-8 -*-
import logging

from django.conf import settings

log = logging.getLogger(__name__)


def variants_key(
    from_key, to_key, date_forward, date_backward, national_version,
    adults=1, children=0, infants=0
):
    return (
        '{root}/{from_key}_{to_key}_{date_forward}_{date_backward}'
        '_economy_{adults}_{children}_{infants}_{national_version}'.format(
            root=settings.WIZARD_SAAS_CACHE_ROOT,
            from_key=from_key,
            to_key=to_key,
            date_forward=date_forward,
            date_backward=date_backward,
            national_version=national_version,
            adults=adults,
            children=children,
            infants=infants,
        )
    )


def cheapest_dates_key(
    from_key, to_key, national_version,
    adults=1, children=0, infants=0
):
    return (
        '{root}/{from_key}_{to_key}_economy_'
        '{adults}_{children}_{infants}_{national_version}'.format(
            root=settings.WIZARD_SAAS_CACHE_ROOT,
            from_key=from_key,
            to_key=to_key,
            national_version=national_version,
            adults=adults,
            children=children,
            infants=infants,
        )
    )
