# -*- coding: utf-8 -*-

from travel.avia.library.python.common.models.geo import Settlement, Station
from travel.avia.library.python.common.models.transport import TransportType


def get_biggest_cities(country, amount=10):
    u"""Формирование списка самых крупных городов по загруженности аэропортов"""

    cities = list(Settlement.hidden_manager.filter(country=country).order_by('-threads_amount')[:amount])
    cities = filter(lambda c: not c.disputed_territory, cities)

    stations = Station.objects.filter(
        settlement__in=cities, t_type=TransportType.PLANE_ID, hidden=False
    ).order_by('title')
    # Если не нашли аэропортов, то ищем станции с любым типом транспорта
    if not stations:
        stations = Station.objects.filter(settlement__in=cities, hidden=False).order_by('title')
    results = {}
    for s in stations:
        results.setdefault(s.settlement.id, []).append(s)

    return [(city, results[city.id]) for city in cities if city.id in results]
