from django.core.management.base import CommandError


def parse_keysets_args(args, groups):
    selected = {group_name: None if keysets is None else set()
                for group_name, keysets in groups.items()}

    unknown_args = []

    for arg in args:
        if ':' in arg:
            group_name, keyset_name = arg.split(':', 1)
        else:
            group_name, keyset_name = arg, None

        if group_name in groups:
            keysets = groups[group_name]

            if keysets is None:
                if not keyset_name:
                    selected[group_name] = True
                    continue
            elif keyset_name:
                if keyset_name in keysets:
                    selected[group_name].add(keyset_name)
                    continue
            else:
                selected[group_name].update(keysets)
                continue

        unknown_args.append(arg)

    if unknown_args:
        raise CommandError("Unknown keysets: %r" % unknown_args)

    return selected
