PY2_LIBRARY(common)

OWNER(g:avia)

PEERDIR(
    contrib/python/Babel
    contrib/python/cachetools
    contrib/python/django-model-utils
    contrib/python/django-simple-history
    contrib/python/django/django-1.11
    contrib/python/enum34
    contrib/python/lxml
    contrib/python/python-memcached
    contrib/python/pytils
    contrib/python/retrying
    contrib/python/scour

    geobase/python/static

    library/python/blackbox
    library/python/cookiemy
    library/python/django
    library/python/resource
    library/python/ylog

    travel/library/python/avia_mdb_replica_info

    travel/avia/library/python/avia_data
    travel/avia/library/python/tester
)

PY_SRCS(
    __init__.py
    activate_this.py
    app_stubs/__init__.py
    app_stubs/currency/__init__.py
    app_stubs/currency/models.py
    app_stubs/importinfo/__init__.py
    app_stubs/importinfo/models.py
    app_stubs/order/__init__.py
    app_stubs/order/models.py
    app_stubs/www/__init__.py
    app_stubs/www/models.py
    bin/cron_run.py
    bin/runpy.py
    cache/__init__.py
    cache/price_list.py
    cache/substitutions.py
    contrib/jsonp_callback_validation.py
    contrib/memcache.py
    forms/__init__.py
    forms/thread.py

    geotargeting/__init__.py
    geotargeting/lookup.py
    geotargeting/middleware.py
    geotargeting/utils.py
    importinfo/__init__.py
    importinfo/models/__init__.py
    importinfo/models/bus.py
    lib/__init__.py
    lib/company_finder.py
    lib/holiday_search_date_provider.py
    lib/mail.py
    lib/timer.py
    maintenance/__init__.py
    maintenance/models.py
    management/__init__.py
    management/commands/__init__.py
    management/commands/load_db_dump.py
    management/commands/run_path.py
    management/commands/update_precache.py
    management/utils/__init__.py
    mdb/__init__.py
    mdb/mysql.py
    middleware/__init__.py
    middleware/host.py
    middleware/language.py
    middleware/locale_request.py
    middleware/mda.py
    middleware/mobiledetect.py
    middleware/mysql_error_handler.py
    middleware/now.py
    middleware/request_activator.py
    middleware/robot_detector.py
    middleware/uatraits_detector.py
    middleware/url_encoding_hack.py
    models/__init__.py
    models/base_partner_model.py
    models/cabin_class.py
    models/compatibility.py
    models/country_covid_info.py
    models/currency.py
    models/disclaimers.py
    models/geo.py
    models/holidays.py
    models/iatacorrection.py
    models/partner.py
    models/schedule.py
    models/scripts.py
    models/service.py
    models/special_tariffs.py
    models/staticpages.py
    models/tariffs.py
    models/team.py
    models/teasers.py
    models/timestamp.py
    models/translations.py
    models/transport.py
    models_abstract/__init__.py
    models_abstract/geo.py
    models_abstract/schedule.py
    models_abstract/tariffs.py
    models_utils/__init__.py
    models_utils/geo.py
    models_utils/i18n.py
    precache/__init__.py
    precache/backend.py
    precache/gunicorn/__init__.py
    precache/gunicorn/conf.py
    precache/manager.py
    precache/proxy_slots.py
    protobuf_converting/__init__.py
    protobuf_converting/big_wizard/__init__.py
    protobuf_converting/big_wizard/search_result_converter.py
    protobuf_converting/big_wizard/search_result_pb2.py
    protobuf_converting/big_wizard/test_flights_protobuf_converter.py
    qloud/__init__.py
    qloud/logging/__init__.py
    saas/__init__.py
    saas/index.py
    saas/json_saas.py
    saas/meta_pb2.py
    saas/search.py
    settings/__init__.py
    settings/db.py
    settings/environment.py
    settings/managed.py
    settings/migration.py
    settings/misc.py
    settings/utils.py
    utils/__init__.py
    utils/antirobot.py
    utils/bemhtml/__init__.py
    utils/bemhtml/template.py
    utils/caching.py
    utils/connectdb.py
    utils/currency_converter.py
    utils/date.py
    utils/dateparser.py
    utils/dcutils.py
    utils/django_utils/__init__.py
    utils/django_utils/meta_helpers.py
    utils/django_utils/utf8_json_serializer.py
    utils/djangofix.py
    utils/dump.py
    utils/environment.py
    utils/errorhandlers.py
    utils/exceptions.py
    utils/fields.py
    utils/files/__init__.py
    utils/files/storage.py
    utils/files/validators.py
    utils/fileutils.py
    utils/geo.py
    utils/geobase.py
    utils/geosnippetter.py
    utils/http.py
    utils/httpcaching.py
    utils/httpresponses.py
    utils/i18n.py
    utils/iterrecipes.py
    utils/jsonutils.py
    utils/locations.py
    utils/logs.py
    utils/lxmlutils.py
    utils/marketstat.py
    utils/mathematic.py
    utils/media_fields.py
    utils/memcache_backend.py
    utils/mobiledetector.py
    utils/models.py
    utils/mysql_switcher/__init__.py
    utils/mysql_switcher/base.py
    utils/mysql_switcher/signals.py
    utils/mysql_try_hard.py
    utils/ping.py
    utils/progress.py
    utils/railway.py
    utils/redirect.py
    utils/regexp.py
    utils/replicastatestore.py
    utils/requests_utils.py
    utils/safe_xml_parser.py
    utils/schema.py
    utils/settlement.py
    utils/tanker.py
    utils/text.py
    utils/threadutils.py
    utils/title_generator.py
    utils/tracer.py
    utils/unicode_csv.py
    utils/warnings.py
    utils/weather.py
    utils/wizard_saas.py
    utils/ya.py
    views/__init__.py
    views/settlement.py
    views/tariffs.py
    views/teasers.py
    views/thread.py
    views/timezones.py
    views/version.py
    xgettext/__init__.py
    xgettext/common.py
    xgettext/i18n.py
    xgettext/management/__init__.py
    xgettext/management/commands/__init__.py
    xgettext/management/commands/base.py
    xgettext/management/commands/tankerdownload.py
    xgettext/management/commands/tankerupload.py
)

RESOURCE_FILES(
    PREFIX travel/avia/library/python/common/

    xgettext/keyset.json
    xgettext/common_keysets/datetemplates-keyset.json
    xgettext/common_keysets/days-keyset.json
    xgettext/common_keysets/months-keyset.json
    xgettext/common_keysets/schedule_autotexts-keyset.json

    fixtures/0010_avia_data_nationalversion_initial.json
    fixtures/0020_www_citymajority_initial.json
    fixtures/0030_www_codesystem_initial.json
    fixtures/0040_www_country_initial.json
    fixtures/0050_www_region_initial.json
    fixtures/0060_www_rthreadtype_initial.json
    fixtures/0080_www_settlement_initial.json
    fixtures/0090_www_stationmajority_initial.json
    fixtures/0100_www_stationtype_initial.json
    fixtures/0005_www_translatedtitle_initial.json
    fixtures/0070_www_transporttype_initial.json
    fixtures/0105_www_team_initial.json
    fixtures/0110_www_service_initial.json
    fixtures/0120_www_cabinclass_initial.json
)

NO_CHECK_IMPORTS()

END()

RECURSE(
    protobuf_converting
    saas
    tests
)

RECURSE_FOR_TESTS(
    tests/py2
)
