from enum import Enum

_CURRENCY_CORRECTION_MAP = {'RUR': 'RUB'}


class Currency(str, Enum):
    RUB = 'RUB'  # never add RUR here
    USD = 'USD'
    UAH = 'UAH'
    EUR = 'EUR'
    KZT = 'KZT'
    BYN = 'BYN'
    UZS = 'UZS'

    @classmethod
    def from_str_with_correction(cls, currency_str):
        return cls(_CURRENCY_CORRECTION_MAP.get(currency_str, currency_str))
