# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import os


def is_qloud():
    return bool(os.getenv('QLOUD_APPLICATION'))


def is_deploy():
    return bool(os.getenv('DEPLOY_STAGE_ID'))


def is_dev():
    return os.getenv('YANDEX_ENVIRONMENT_TYPE') in ('development', 'dev')


def parse_env_list(values_string, converter=lambda x: x, separator=','):
    result = []
    for value in (values_string or '').split(separator):
        value = value.strip()
        if value:
            result.append(converter(value))
    return result
