from __future__ import absolute_import

import os


class EnvironmentVariableProvider:
    def __init__(self, service_name):
        self.service_name = service_name

    def get(self, name, required=True, default=None):
        full_name = '{}_{}'.format(self.service_name, name).upper()
        if required:
            return os.environ[full_name]
        return os.environ.get(full_name, default)
