from __future__ import absolute_import, unicode_literals

import os

from raven.base import Client
from raven.conf.remote import RemoteConfig
from six import python_2_unicode_compatible

from travel.avia.library.python.error_booster.raven.sentry import EventConverter


class RavenErrorBoosterClient(Client):

    def __init__(self, service, environment, dc, project='avia', **options):
        self._service = service
        self._environment = environment
        self._dc = dc
        self._project = project

        super(RavenErrorBoosterClient, self).__init__(**options)

    def _create_remote_config(self):
        return None

    def _error_booster_convert(self, data):
        converted = EventConverter.convert(data)
        converted.update({
            'project': self._project,
            'service': self._service,
            'dc': self._dc,
            'env': self._environment,
            'language': 'python',
        })

        converted['message'] = '[{}] {}'.format(self._service, converted['message'])

        if os.getenv('DEPLOY_STAGE_ID'):
            converted['additional']['deploy'] = {
                'DEPLOY_NODE_DC': os.getenv('DEPLOY_NODE_DC'),
                'DEPLOY_BOX_ID': os.getenv('DEPLOY_BOX_ID'),
                'DEPLOY_UNIT_ID': os.getenv('DEPLOY_UNIT_ID'),
                'DEPLOY_STAGE_ID': os.getenv('DEPLOY_STAGE_ID'),
                'DEPLOY_POD_ID': os.getenv('DEPLOY_POD_ID'),
                'DEPLOY_PROJECT_ID': os.getenv('DEPLOY_PROJECT_ID'),
                'DEPLOY_POD_PERSISTENT_FQDN': os.getenv('DEPLOY_POD_PERSISTENT_FQDN'),
            }

        return converted

    def set_dsn(self, dsn=None, transport=None):
        if dsn not in self._transport_cache:
            result = self._create_remote_config()
            self._transport_cache[dsn] = result
            self.remote = result
        else:
            self.remote = self._transport_cache[dsn]

        self.logger.debug('Configuring Raven for host: %s', self.remote)

    def decode(self, data):
        if isinstance(data, dict):
            return data

        return super(RavenErrorBoosterClient, self).decode(data)

    def send(self, auth_header=None, **data):
        converted_data = self._error_booster_convert(data)

        return self.send_remote(
            url=self.remote.store_endpoint,
            data=converted_data,
        )


@python_2_unicode_compatible
class RavenErrorBoosterRemoteConfig(RemoteConfig):
    def __init__(self, *args, **kwargs):
        super(RavenErrorBoosterRemoteConfig, self).__init__(*args, **kwargs)
        self.store_endpoint = 'error booster project: {}'.format(self.project)

    def is_active(self):
        return bool(self.project)

    def __str__(self):
        return self.store_endpoint
