from requests import Session

from raven.transport.base import Transport

from travel.avia.library.python.error_booster.raven import RavenErrorBoosterClient, RavenErrorBoosterRemoteConfig


class RavenErrorBoosterUnifiedAgentClient(RavenErrorBoosterClient):
    def __init__(self, error_booster_host, error_booster_port, service, environment, dc, project='avia', **options):
        self._error_booster_host = error_booster_host
        self._error_booster_port = error_booster_port

        super(RavenErrorBoosterUnifiedAgentClient, self).__init__(service, environment, dc, project, **options)

    def _create_remote_config(self):
        return RavenErrorBoosterRemoteConfig(
            transport=RavenErrorBoosterUnifiedAgentTransport,
            options={
                'error_booster_host': self._error_booster_host,
                'error_booster_port': self._error_booster_port,
            },
            project=self._project,
        )


class RavenErrorBoosterUnifiedAgentTransport(Transport):
    REQUEST_TIMEOUT = 1

    def __init__(self, error_booster_host, error_booster_port):
        self._uri = 'http://{}:{}/errorbooster'.format(error_booster_host, error_booster_port)
        self._session = Session()

    def send(self, url, data, headers):
        self._session.post(
            self._uri,
            json=data,
            timeout=self.REQUEST_TIMEOUT,
        )
