# -*- coding: utf-8 -*-
from abc import ABCMeta, abstractmethod


class IABFlagsContent:
    __metaclass__ = ABCMeta

    @abstractmethod
    def flag_enabled(self, flag):
        # type: (str) -> bool
        pass


class ABFlagsContent(IABFlagsContent):
    def __init__(self, ab_flags):
        self.ab_flags = ab_flags

    def flag_enabled(self, flag):
        return self.ab_flags.get(flag) == '1'

    def __repr__(self):
        return u'<ABFlagsContent flags={!r}>'.format(
            self.ab_flags,
        )
